

<?php $__env->startSection('title', 'Roles Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="roles-management">
    <div class="dashboard-header">
        <h1>Role Management</h1>
        <p>Create and manage user roles and their permissions</p>
    </div>

    <div class="users-header">
        <div class="title">
            <h2>Roles</h2>
        </div>
        <div class="users-actions">
            <a href="<?php echo e(route('admin.roles.create')); ?>" class="btn btn-primary">
                <i class="fas fa-plus"></i> Create New Role
            </a>
        </div>
    </div>

    <div class="roles-grid">
        <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="role-card">
                <div class="role-header">
                    <h3>
                        <span class="role-badge" style="background-color: <?php echo e($role->color ?? '#4B8BFF'); ?>"></span>
                        <?php echo e($role->name); ?>

                    </h3>
                    <div class="role-actions">
                        <a href="<?php echo e(route('admin.roles.edit', $role)); ?>" class="btn-icon btn-primary" title="Edit Role">
                            <i class="fas fa-edit"></i>
                        </a>
                        <?php if(!in_array($role->name, ['super-admin', 'admin'])): ?>
                            <form action="<?php echo e(route('admin.roles.destroy', $role)); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn-icon btn-danger" 
                                        onclick="return confirm('Are you sure you want to delete this role?')"
                                        title="Delete Role">
                                    <i class="fas fa-trash-alt"></i>
                                </button>
                            </form>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="role-body">
                    <div class="role-description">
                        <p>Permissions assigned to this role:</p>
                    </div>
                    <div class="permissions-container">
                        <?php if($role->permissions->count() > 0): ?>
                            <div class="permissions-list">
                                <?php $__currentLoopData = $role->permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="permission-item">
                                        <i class="fas fa-check-circle"></i>
                                        <span><?php echo e($permission->name); ?></span>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php else: ?>
                            <div class="no-permissions">
                                <i class="fas fa-exclamation-circle"></i>
                                <p>No permissions assigned to this role.</p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/siedestudios.co.uk/edge/resources/views/admin/roles/index.blade.php ENDPATH**/ ?>